/* Adobe.Fader.js */

define([], 
function() {
	"use strict";
    
	return {
		description:	"$$$/animal/Behavior/Fader/Desc=When triggered, fades opacity up; when trigger released, fades opacity down",
		uiName:			"$$$/animal/Behavior/Fader/UIName=Fader",

		defineParams: function () {
			return [
				// doesn't make sense to show these two parameters until there's a way to have untriggered
				//	layers not be invisible; also, maybe the untriggered opacity should come from the
				//	layer's original opacity instead of a parameter
                {id:"untriggeredOpacity",	type:"slider",
				 	uiName:"$$$/private/animal/Behavior/Fader/Param/UntriggeredOpacity=Untriggered Opacity",
				 	min:0, max:100, dephault:0, uiUnits:"%",
					hidden: true},
                {id:"triggeredOpacity",		type:"slider",
				 	uiName:"$$$/private/animal/Behavior/Fader/Param/TriggeredOpacity=Triggered Opacity",
				 	min:0, max:100, dephault:100, uiUnits:"%",
					hidden: true},
				
                {id:"duration",				type:"slider",
				 	uiName:"$$$/animal/Behavior/Fader/Param/FadeDuration=Duration",
				 	min:0.01, max:9999, dephault:0.5, precision: 1,
				 	uiUnits:"$$$/animal/Behavior/Dragger/units/sec=sec"},
			];
		},
		
		onCreateBackStageBehavior: function (/*self*/) {
			return {
				order : 0.0,
				importance : 1.0		// untuned
			};
		},
		
		onCreateStageBehavior: function (self, args) {
            self.bFirstTime = true;
			self.originalOpacity = args.stageLayer.getOpacity();
		},
		
		onResetRehearsalData : function (self) {
			// here we don't want to reset _everything_, because we don't want stopping playback
			//	while triggered and unarmed to flash back to transparent for a moment
			//	but we do want to reset any active fading and just jump to 0 or 100% opacity
			self.bReset = true;
		},
		
		onAnimate: function (self, args) {
            var duration = args.getParam("duration"),
                untriggeredOpacity = args.getParam("untriggeredOpacity")/100,
                triggeredOpacity = args.getParam("triggeredOpacity")/100,
                changePerSecond = (triggeredOpacity - untriggeredOpacity)/duration,
                triggeringLayer0 = args.getTriggeringLayer(),
                bRealTrigger = !!triggeringLayer0,
                bJustTriggered = (bRealTrigger && !self.bWasActive),
                bJustUnTriggered = (!bRealTrigger && self.bWasActive),
                t = args.t + args.globalRehearseTime,
                opacity = untriggeredOpacity;
			
            if (self.bFirstTime) {
                self.lastOpacity = untriggeredOpacity;
            }
			
			if (triggeringLayer0) {
				// TODO: factor into sdkLayer.getTriggerMutexPriority()
				//	may be undefined if not hide-siblings going on
				self.realTriggerPriority = triggeringLayer0.getParentLayer().privateLayer.triggerMutexPriority;
			}

			if (bJustTriggered || bJustUnTriggered) {	// always just one or the other, never both
                self.start = self.lastOpacity;
                self.end = bJustTriggered ? triggeredOpacity : untriggeredOpacity;
                self.slope = bJustTriggered ? changePerSecond : -changePerSecond;
                self.bRevertPhase = bJustUnTriggered;
                self.lastTriggerTime = t - args.dt;	// start off one step into the change, otherwise it's a frame behind
				// e.g. at 4 fps, we want the first triggered frame to be 25%, then 50%, 75%, 100%
			}

			if (bRealTrigger || self.bRevertPhase) {
				//console.logToUser(`bRealTrigger = ${bRealTrigger}, bRevertPhase = ${self.bRevertPhase}, self.lastTriggerTime = ${self.lastTriggerTime}, t = ${t}, self.bReset = ${self.bReset}`);
				
				if (self.lastTriggerTime === undefined || self.lastTriggerTime + args.dt > t || self.bReset) {
					// backwards scrubbing before trigger starting, or time-jump/play-stop; don't fade at all
					opacity = bRealTrigger ? triggeredOpacity : untriggeredOpacity;
					self.bRevertPhase = false;
					self.lastTriggerTime = undefined;
					//console.logToUser(`slammed opacity = ${opacity}`);
				} else {
					var bReachedEnd = false,
						dt = t - self.lastTriggerTime;	// here we know that lastTriggerTime <= t

					opacity = self.start + (self.slope * dt);
					if (self.slope >= 0) {	// increasing (or flat); make sure didn't overshoot
						 if (opacity >= self.end) {
							bReachedEnd = true;
						 }
					} else {				// decreasing; make sure didn't undershoot
						if (opacity < self.end) {
							bReachedEnd = true;
						}
					}

					if (bReachedEnd) {
						opacity = self.end;	// make it exact
						self.bRevertPhase = false;
					}

					if (self.bRevertPhase) {
						//console.logToUser("Sustaining with priority " + self.realTriggerPriority);
						// note that without the priority passed here, a keyboard-triggered layer
						//	wouldn't override, say, a Cycle Layers-triggered layer in front of it
						args.sustainTrigger(self.realTriggerPriority);
					}
				}
            } else {
                self.lastTriggerTime = undefined;
            }
			
			// Force group blending if the blend mode isn't specified.
			var blendMode = args.stageLayer.getBlendMode();
			if (blendMode === null) {
				args.stageLayer.setBlendMode("In Front");
			}
			
			var opa = opacity * self.originalOpacity;
			
			// this check should not be necessary; just a safety thing when fixing DVACH-2063 just before RC
			if (opa < 0 || isNaN(opa)) {
				opa = 0;
			} else if (opa > 1) {
				opa = 1;
			}
			
			args.stageLayer.setOpacity(opa);
			
            self.bFirstTime = false;
            self.bWasActive = bRealTrigger;
            self.lastOpacity = opacity;
			self.bReset = false;
		}
			
	};
});
